<?php
session_start(); // Mulakan sesi

// Import sambungan ke pangkalan data
require '../../intro/config.php'; // Pastikan fail ini mempunyai sambungan $conn

// Semak jika pengguna log masuk
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$username = $_SESSION['username']; // Ambil username dari sesi

// Dapatkan skor daripada GET parameter
$score = isset($_GET['score']) ? (int)$_GET['score'] : 0;
$totalQuestions = 100;

// Simpan skor ke dalam jadual `makanansihat`
$sql = "INSERT INTO makanansihat (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("si", $username, $score);
    
    if (!$stmt->execute()) {
        die("Ralat semasa menyimpan skor: " . $stmt->error);
    }

    $stmt->close();
} else {
    die("Ralat penyediaan pernyataan: " . $conn->error);
}

// Tutup sambungan
$conn->close();
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Akhir</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="end-container">
    <h1>🌟 Tahniah! 🎉</h1>
    <p>Anda telah menyelesaikan permainan.</p>
    <p><strong>Skor Akhir: <?= htmlspecialchars($score) ?> / <?= htmlspecialchars($totalQuestions) ?></strong></p>
    <a href="../../murid5/indexTahun5.php" class="restart-btn">Kembali Ke Halaman Utama</a>
</div>
</body>
</html>
